var fark;
const getRates = (x) => {
    $.get("http://85.99.251.47/apiFarklar.php", function(data, status){
          data = JSON.parse(data)
          fark = data;

         if (x) connectSocket();
    });
}
var dovizler = ["USDTRY", "EURTRY", "GBPTRY", "CHF", "AUD", "CAD", "CNY", "DKK", "NOK", "SEK", "SAR", "RUB", "JPY", "KWD", "AED", "BGN", "QAR", "EURUSD"]

getRates(true);

var socket;
var keyElement, keyElementAlis, keyElementSatis, alis, satis, yuzde;
function connectSocket() {
    socket = connectPrice('http://85.99.251.47:4000', function(keys) {
        getRates()

        for (var i = 0; i < keys.length; i++) {
            const key = keys[i]

            key.code = key.code.toUpperCase()

            if (key.code && document.getElementById(key.code)) {
                
                keyElement = $(`#${key.code}`);
                keyElementAlis = $(`#${key.code} > #bid > div`);
                keyElementSatis = $(`#${key.code} > #ask > div`);

                alis = parseFloat(key.alis) - parseFloat(fark[key.code]["ALIS"]);
                satis = parseFloat(key.satis) + parseFloat(fark[key.code]["SATIS"]);

                if (dovizler.includes(key.code)) {
                    if (key.code !== "EURUSD")  {
                        keyElementAlis.text(roundRatesForBuy(alis, 2));
                        keyElementSatis.text(roundRatesForSell(satis, 2));
                    } else {
                        keyElementAlis.text(alis.toFixed(3));
                        keyElementSatis.text(satis.toFixed(3));
                    }
                } else {
                    keyElementAlis.text(numberWithCommas(roundRatesForBuy(alis)));
                    keyElementSatis.text(numberWithCommas(roundRatesForSell(satis)));

                    if (key.code === "HAS") {
                        key.code = "AYAR22"

                        keyElement = $(`#${key.code}`);
                        keyElementAlis = $(`#${key.code} > #bid > div`);
                        keyElementSatis = $(`#${key.code} > #ask > div`);


                        alis = parseFloat(key.alis) * parseFloat(fark[key.code]["ALIS"]);
                        satis = parseFloat(key.satis) * parseFloat(fark[key.code]["SATIS"]);

                        keyElementAlis.text(numberWithCommas(roundRatesForBuy(alis)));
                        keyElementSatis.text(numberWithCommas(roundRatesForSell(satis)));

                        key.code = "AYAR14"

                        keyElement = $(`#${key.code}`);
                        keyElementAlis = $(`#${key.code} > #bid > div`);
                        keyElementSatis = $(`#${key.code} > #ask > div`);


                        alis = parseFloat(key.alis) * parseFloat(fark[key.code]["ALIS"]);
                        satis = parseFloat(key.satis) * parseFloat(fark[key.code]["SATIS"]);

                        keyElementAlis.text(numberWithCommas(roundRatesForBuy(alis)));
                        keyElementSatis.text(numberWithCommas(roundRatesForSell(satis)));

                    }
                }
            }
        }
    })
}

const numberWithCommas = (x) => {
  return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

const roundRatesForBuy = (price, fixZeros = 0) => {
    if (price === 0) return price

    const numbers = price.toFixed(fixZeros).toString().split("")
    const _numbers = []

    let lastItem = parseFloat(numbers.pop())

    for (var i = 0; i < numbers.length; i++) {
        _numbers.push(numbers[i])
    }

    if (lastItem > 5) _numbers.push(5)
        else _numbers.push(0)

    return parseFloat(_numbers.join("")).toFixed(fixZeros)
}

const roundRatesForSell = (price, fixZeros = 0) => {
    if (price === 0) return price

    const numbers = price.toFixed(fixZeros).toString().split("")
    const _numbers = []
    let number;

    let lastItem = parseFloat(numbers.pop())

    for (var i = 0; i < numbers.length; i++) {
        _numbers.push(numbers[i])
    }

    if (fixZeros === 0) {
        number = (((parseFloat(_numbers.join(''))).toFixed(fixZeros)) * 10) + Math.round((lastItem+10)/10)*10/2
    }
    else {
        number = parseFloat(_numbers.join('')) + (Math.round((lastItem+10)/10)*10/2)/100
    }

    return number.toFixed(fixZeros) 
}

function connectPrice(server, callback, callbackConnect) {
    try {
        socket.off("connect");
        socket.off("price:updated");
        socket.off("disconnect");
        socket.disconnect();
    } catch (ex) {}
    
    socket = io.connect(server, { transports: ["websocket", "polling"] });

    socket.on("connect", function () {
    });
    socket.on("price:updated", function (recData) {
    return callback(recData);
    });

    return socket;
}